/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.main.Main;
import net.minecraft.server.MinecraftServer;

public class WorldInfoShared {
    public long randomSeed;
    public long random_seed_hashed;
    public acg terrainType;
    public String generatorOptions = "";
    public int spawnX;
    public int spawnY;
    public int spawnZ;
    private long[] totalTime = new long[4];
    public long lastTimePlayed;
    public long sizeOnDisk;
    public by playerTag;
    public int dimension;
    public String levelName;
    public int saveVersion;
    public ace theGameType;
    public boolean mapFeaturesEnabled;
    public boolean hardcore;
    public boolean allowCommands;
    public boolean initialized;
    public abt theGameRules;
    protected byte village_conditions;
    protected int earliest_MITE_release_run_in = 195;
    protected int latest_MITE_release_run_in = 195;
    protected int earliest_allowable_MITE_release;
    public boolean is_valid_MITE_world = true;
    public String is_not_valid_reason;
    public int sacred_stones_placed;
    protected List curses = new ArrayList();
    public long world_creation_time;
    public long nanotime;
    public boolean the_underworld_has_been_visited;
    public boolean the_nether_has_been_visited;
    public boolean are_skills_enabled;
    private List uniques = new ArrayList();
    private HashMap achievements = new HashMap();

    public WorldInfoShared() {
        this.terrainType = acg.b;
        this.theGameRules = new abt();
    }

    private long getRandomSeedHashed(long random_seed) {
        Random random = new Random(random_seed);
        random.nextInt();
        return random.nextLong();
    }

    public WorldInfoShared(by par1NBTTagCompound) {
        int i2;
        this.terrainType = acg.b;
        this.theGameRules = new abt();
        this.randomSeed = par1NBTTagCompound.f("RandomSeed");
        this.random_seed_hashed = this.getRandomSeedHashed(this.randomSeed);
        if (par1NBTTagCompound.b("generatorName")) {
            String var2 = par1NBTTagCompound.i("generatorName");
            this.terrainType = acg.a(var2);
            if (this.terrainType == null) {
                this.terrainType = acg.b;
            } else if (this.terrainType.e()) {
                int var3 = 0;
                if (par1NBTTagCompound.b("generatorVersion")) {
                    var3 = par1NBTTagCompound.e("generatorVersion");
                }
                this.terrainType = this.terrainType.a(var3);
            }
            if (par1NBTTagCompound.b("generatorOptions")) {
                this.generatorOptions = par1NBTTagCompound.i("generatorOptions");
            }
        }
        this.theGameType = ace.a(par1NBTTagCompound.e("GameType"));
        this.mapFeaturesEnabled = par1NBTTagCompound.b("MapFeatures") ? par1NBTTagCompound.n("MapFeatures") : true;
        this.spawnX = par1NBTTagCompound.e("SpawnX");
        this.spawnY = par1NBTTagCompound.e("SpawnY");
        this.spawnZ = par1NBTTagCompound.e("SpawnZ");
        for (int i3 = 0; i3 < this.totalTime.length; ++i3) {
            this.totalTime[i3] = par1NBTTagCompound.f("Time" + i3);
        }
        if (par1NBTTagCompound.b("Time") || par1NBTTagCompound.b("DayTime")) {
            this.is_valid_MITE_world = false;
            this.is_not_valid_reason = Translator.get("invalidWorld.outdated");
        }
        this.lastTimePlayed = par1NBTTagCompound.f("LastPlayed");
        this.sizeOnDisk = par1NBTTagCompound.f("SizeOnDisk");
        this.levelName = par1NBTTagCompound.i("LevelName");
        this.saveVersion = par1NBTTagCompound.e("version");
        this.hardcore = par1NBTTagCompound.n("hardcore");
        this.initialized = par1NBTTagCompound.b("initialized") ? par1NBTTagCompound.n("initialized") : true;
        if (par1NBTTagCompound.b("allowCommands")) {
            this.allowCommands = par1NBTTagCompound.n("allowCommands");
        } else {
            boolean bl2 = this.allowCommands = this.theGameType == ace.c;
        }
        if (!(par1NBTTagCompound.b("last_run_on_MITE_DS") && !Main.is_MITE_DS || !par1NBTTagCompound.b("last_run_on_MITE_DS") && Main.is_MITE_DS || !par1NBTTagCompound.b("Player"))) {
            this.playerTag = par1NBTTagCompound.l("Player");
            this.dimension = this.playerTag.e("Dimension");
        }
        if (par1NBTTagCompound.b("GameRules")) {
            this.theGameRules.a(par1NBTTagCompound.l("GameRules"));
        }
        this.village_conditions = par1NBTTagCompound.c("village_conditions");
        if (par1NBTTagCompound.b("earliest_MITE_release_run_in")) {
            this.earliest_MITE_release_run_in = par1NBTTagCompound.e("earliest_MITE_release_run_in");
        } else {
            this.earliest_MITE_release_run_in = 0;
            this.is_valid_MITE_world = false;
        }
        if (par1NBTTagCompound.b("latest_MITE_release_run_in")) {
            this.latest_MITE_release_run_in = par1NBTTagCompound.e("latest_MITE_release_run_in");
        } else {
            this.is_valid_MITE_world = false;
        }
        if (this.earliest_MITE_release_run_in < 173) {
            this.is_valid_MITE_world = false;
            this.is_not_valid_reason = Translator.get("invalidWorld.outdated");
        } else {
            int[] incompatible_releases = atv.incompatible_releases;
            for (i2 = 0; i2 < incompatible_releases.length; ++i2) {
                if (this.earliest_MITE_release_run_in != incompatible_releases[i2] && this.latest_MITE_release_run_in != incompatible_releases[i2]) continue;
                this.is_valid_MITE_world = false;
                this.is_not_valid_reason = Translator.get("invalidWorld.incompatible");
                break;
            }
        }
        if (this.latest_MITE_release_run_in < 195) {
            this.latest_MITE_release_run_in = 195;
        } else if (this.latest_MITE_release_run_in > 195) {
            this.is_valid_MITE_world = false;
            this.is_not_valid_reason = Translator.getFormatted("invalidWorld.needsRelease", this.latest_MITE_release_run_in);
        }
        if (par1NBTTagCompound.b("earliest_allowable_MITE_release")) {
            this.earliest_allowable_MITE_release = par1NBTTagCompound.e("earliest_allowable_MITE_release");
        }
        if (this.earliest_allowable_MITE_release > 195) {
            this.is_valid_MITE_world = false;
            this.is_not_valid_reason = Translator.getFormatted("invalidWorld.needsRelease", this.earliest_allowable_MITE_release);
        }
        if (par1NBTTagCompound.b("curses")) {
            String[] curses = par1NBTTagCompound.i("curses").split("\\|");
            for (i2 = 0; i2 < curses.length; ++i2) {
                String[] curse_fields = curses[i2].split(":");
                Curse curse = new Curse(curse_fields[0], UUID.fromString(curse_fields[1]), Curse.cursesList[Integer.valueOf(curse_fields[2])], Long.valueOf(curse_fields[3]), Boolean.valueOf(curse_fields[4]), Boolean.valueOf(curse_fields[5]));
                curse.effect_has_already_been_learned = curse.effect_known;
                this.curses.add(curse);
            }
        }
        if (par1NBTTagCompound.b("sacred_stones_placed")) {
            this.sacred_stones_placed = par1NBTTagCompound.e("sacred_stones_placed");
        }
        this.the_underworld_has_been_visited = par1NBTTagCompound.n("the_underworld_has_been_visited");
        this.the_nether_has_been_visited = par1NBTTagCompound.n("the_nether_has_been_visited");
        this.are_skills_enabled = par1NBTTagCompound.n("are_skills_enabled");
        if (this.initialized) {
            if (par1NBTTagCompound.b("world_creation_time")) {
                this.world_creation_time = par1NBTTagCompound.f("world_creation_time");
            } else {
                this.is_valid_MITE_world = false;
            }
            if (par1NBTTagCompound.b("nanotime")) {
                this.nanotime = par1NBTTagCompound.f("nanotime");
            } else {
                this.is_valid_MITE_world = false;
            }
            if (this.nanotime != (long)this.calcChecksum()) {
                this.is_valid_MITE_world = false;
            }
        }
        if (!this.is_valid_MITE_world && MinecraftServer.F() instanceof is) {
            System.out.println(this.is_not_valid_reason == null ? "Invalid world" : this.is_not_valid_reason);
            System.exit(0);
        }
        if (par1NBTTagCompound.b("uniques")) {
            int[] uniques = par1NBTTagCompound.k("uniques");
            this.uniques.clear();
            for (i2 = 0; i2 < uniques.length; ++i2) {
                this.uniques.add(uniques[i2]);
            }
        }
        if (par1NBTTagCompound.b("achievements")) {
            cg achievements = par1NBTTagCompound.m("achievements");
            this.achievements.clear();
            for (i2 = 0; i2 < achievements.c(); ++i2) {
                WorldAchievement wa2 = new WorldAchievement((by)achievements.b(i2));
                this.achievements.put(wa2.achievement, wa2);
            }
        }
    }

    public WorldInfoShared(acd world_settings, String level_name) {
        this.terrainType = acg.b;
        this.theGameRules = new abt();
        this.randomSeed = world_settings.d();
        this.random_seed_hashed = this.getRandomSeedHashed(this.randomSeed);
        this.theGameType = world_settings.e();
        this.mapFeaturesEnabled = world_settings.g();
        this.levelName = level_name;
        this.hardcore = world_settings.f();
        this.terrainType = world_settings.h();
        this.generatorOptions = world_settings.j();
        this.allowCommands = world_settings.i();
        this.initialized = false;
        this.are_skills_enabled = world_settings.areSkillsEnabled();
    }

    public void updateTagCompound(by par1NBTTagCompound, by par2NBTTagCompound) {
        par1NBTTagCompound.a("RandomSeed", this.randomSeed);
        par1NBTTagCompound.a("generatorName", this.terrainType.a());
        par1NBTTagCompound.a("generatorVersion", this.terrainType.c());
        par1NBTTagCompound.a("generatorOptions", this.generatorOptions);
        par1NBTTagCompound.a("GameType", this.theGameType.a());
        par1NBTTagCompound.a("MapFeatures", this.mapFeaturesEnabled);
        par1NBTTagCompound.a("SpawnX", this.spawnX);
        par1NBTTagCompound.a("SpawnY", this.spawnY);
        par1NBTTagCompound.a("SpawnZ", this.spawnZ);
        for (int i2 = 0; i2 < this.totalTime.length; ++i2) {
            par1NBTTagCompound.a("Time" + i2, this.totalTime[i2]);
        }
        par1NBTTagCompound.a("SizeOnDisk", this.sizeOnDisk);
        par1NBTTagCompound.a("LastPlayed", MinecraftServer.aq());
        par1NBTTagCompound.a("LevelName", this.levelName);
        par1NBTTagCompound.a("version", this.saveVersion);
        par1NBTTagCompound.a("hardcore", this.hardcore);
        par1NBTTagCompound.a("allowCommands", this.allowCommands);
        par1NBTTagCompound.a("initialized", this.initialized);
        par1NBTTagCompound.a("GameRules", this.theGameRules.a());
        par1NBTTagCompound.a("village_conditions", this.village_conditions);
        par1NBTTagCompound.a("earliest_MITE_release_run_in", this.earliest_MITE_release_run_in);
        par1NBTTagCompound.a("latest_MITE_release_run_in", this.latest_MITE_release_run_in);
        par1NBTTagCompound.a("earliest_allowable_MITE_release", this.earliest_allowable_MITE_release);
        if (Main.is_MITE_DS) {
            par1NBTTagCompound.a("last_run_on_MITE_DS", true);
        }
        if (par2NBTTagCompound != null) {
            par1NBTTagCompound.a("Player", par2NBTTagCompound);
        }
        if (!this.curses.isEmpty()) {
            StringBuffer sb2 = new StringBuffer();
            for (Curse curse : this.curses) {
                sb2.append('|');
                sb2.append(curse.cursed_player_username);
                sb2.append(':');
                sb2.append(curse.cursing_entity_uuid.toString());
                sb2.append(':');
                sb2.append(curse.id);
                sb2.append(':');
                sb2.append(curse.time_of_realization);
                sb2.append(':');
                sb2.append(curse.has_been_realized);
                sb2.append(':');
                sb2.append(curse.effect_known);
            }
            par1NBTTagCompound.a("curses", sb2.substring(1));
        }
        par1NBTTagCompound.a("sacred_stones_placed", this.sacred_stones_placed);
        par1NBTTagCompound.a("the_underworld_has_been_visited", this.the_underworld_has_been_visited);
        par1NBTTagCompound.a("the_nether_has_been_visited", this.the_nether_has_been_visited);
        if (this.are_skills_enabled) {
            par1NBTTagCompound.a("are_skills_enabled", this.are_skills_enabled);
        }
        if (this.world_creation_time != 0L) {
            par1NBTTagCompound.a("world_creation_time", this.world_creation_time);
            par1NBTTagCompound.a("nanotime", this.nanotime);
        }
        if (this.uniques.size() > 0) {
            int[] uniques = new int[this.uniques.size()];
            for (int i3 = 0; i3 < uniques.length; ++i3) {
                uniques[i3] = (Integer)this.uniques.get(i3);
            }
            par1NBTTagCompound.a("uniques", uniques);
        }
        if (this.achievements.size() > 0) {
            cg achievements = new cg();
            for (Map.Entry entry : this.achievements.entrySet()) {
                achievements.a(((WorldAchievement)entry.getValue()).getAsNBTTagCompound());
            }
            par1NBTTagCompound.a("achievements", achievements);
        }
    }

    public int calcChecksum() {
        int checksum = 0;
        checksum += this.earliest_MITE_release_run_in * 67;
        checksum += (int)this.randomSeed * 83;
        checksum = (int)((long)checksum + this.world_creation_time * 561L);
        return checksum;
    }

    public boolean hasSignatureBeenAdded(int id2) {
        return this.uniques.contains(id2);
    }

    public void addSignature(int id2) {
        if (this.hasSignatureBeenAdded(id2)) {
            atv.setErrorMessage("addSignature: signature already exists in list " + id2);
            return;
        }
        if (atv.inDevMode()) {
            System.out.println("Unique added to world, signature=" + id2);
        }
        this.uniques.add(id2);
    }

    public boolean removeSignature(int id2) {
        if (atv.inDevMode()) {
            System.out.println("removeSignature: trying to remove " + id2);
        }
        return this.hasSignatureBeenAdded(id2) && this.uniques.remove(new Integer(id2));
    }

    public int getNumSignatures() {
        return this.uniques.size();
    }

    public boolean hasAchievementUnlocked(ko achievement) {
        return this.achievements.containsKey(achievement);
    }

    public void unlockAchievement(ko achievement, String username, int day, boolean update_clients) {
        if (!this.hasAchievementUnlocked(achievement)) {
            this.achievements.put(achievement, new WorldAchievement(achievement, username, day));
            if (update_clients) {
                MinecraftServer.F();
                MinecraftServer.sendPacketToAllPlayersOnServer(new Packet93WorldAchievement(achievement, username, day));
            }
        }
    }

    public void unlockAchievement(ko achievement, uf player) {
        this.unlockAchievement(achievement, player.bu, player.q.getDayOfWorld(), player instanceof jv);
    }

    public void setAchievements(HashMap achievements) {
        this.achievements = achievements;
    }

    public HashMap getAchievements() {
        return this.achievements;
    }

    public WorldAchievement getWorldAchievement(ko achievement) {
        return (WorldAchievement)this.achievements.get(achievement);
    }

    public boolean haveAchievementsBeenUnlockedByOtherPlayers(uf player) {
        for (Map.Entry entry : this.achievements.entrySet()) {
            WorldAchievement wa2 = (WorldAchievement)entry.getValue();
            if (player.bu.equals(wa2.username)) continue;
            return true;
        }
        return false;
    }

    private static int getWorldIndexForDimensionId(int dimension_id) {
        return MinecraftServer.getWorldIndexForDimensionId(dimension_id);
    }

    public void setTotalWorldTime(abw world, long total_world_time) {
        this.totalTime[WorldInfoShared.getWorldIndexForDimensionId((int)world.getDimensionId())] = total_world_time;
        world.updateTickFlags();
    }

    public void setTotalWorldTimes(long[] total_world_times, bdd world) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.totalTime[i2] = total_world_times[i2];
        }
        world.updateTickFlags();
    }

    public long getTotalWorldTime(int dimension_id) {
        return this.totalTime[WorldInfoShared.getWorldIndexForDimensionId(dimension_id)];
    }
}

